--  -   fighter_xx
--    RETURN,         0  2
--: return 1
-- 0 -     
-- 1 -        
-- 2 -          

function printVisibleInfo(sUnit)
	local collectVisibleEnemies = function(index, human)
		if(	IsAlive(human.id) and
			(relations(team(sUnit),team(human.id))==ENEMY) and
			canOneSeeOther(sUnit,human.id)) then
			log(sUnit,"*** I see ",human.id)
	        end
	end

	log(sUnit,"****** True  visible")	
	table.foreach(Humans, collectVisibleEnemies)

	if(Humans[sUnit].visible_enemies) then

		local reportAboutSavedVisibleEnemy = function(name, visible)
			if((name~="size") and visible) then
				log(sUnit,"*** I see ",name)
			end
		end

		log(sUnit,"****** Saved visible")	
		table.foreach(Humans[sUnit].visible_enemies, reportAboutSavedVisibleEnemy)
	end
end

b_soldier = 
{
--------------------
--SOLDIER BEHAVIOR--
--------------------
-----TURN BASED-----
--------------------

	checkForDisappear = function(id)
		if(service.isUnitInBlackZone(id) and
			(Humans[id].retreat or
			((Humans[id].surrounded ~= true) and (Humans[id].surrounded ~= false)))) then
			log(id,"*** Disappear now...")
			endOfTurn(id)
			local rel = relations(team(id),PLAYER)
			sendMessage(rel.."_disappeared", NEW_ENTRY)
			if(rel==ENEMY) then
				local merc = getRandomMerc()
				if(isUnitValid(merc)) then
					local count = math.random(2)
					service.showAck(merc,merc.."_enemy_retreat_0"..count,1.0)
				end
			end
			disappear(id)
			Sectors[CUR_MISSION.Name].onKill()
			log(id,"*** Disappear done.")
			return(true)
		end
		return(false)
	end,

	getGrenadeMistake = function(id)
		local health = getPersonParameter(id, "HEALTH")
		local fullHealth = getPersonParameter(id, "DURABILITYMAX")
		local mistake = getAIConst().maxGrenadeMistake*(1-health/fullHealth)+1
		if(getPersonParameter(id, "SKILL1")=="THROWING") then
		        mistake = mistake*2/3
		end
		if(getPersonParameter(id, "SKILL2")=="THROWING") then
			mistake = mistake*2/3
		end
		return(mistake)
	end,

	attackTargetByGrenade = function(id,target)
		local hasGrenade = getGrenade(id, "not_stun")
		if (hasGrenade ~= -1) then
			log(id, "I have a grenade for",target)
			local dist = service.person2person_distance(id, target)
			if((dist > getAIConst().minGrenadeRange) and (dist < grenadeMaxDistance(id))) then
				log(id, "and target is far enough")
				if (service.isTargetDangerous(target) and 
					(relations(team(id),team(target)) == ENEMY)) then
					log(id, "and target is DANGEROUS")
					if( (Humans[target].blasted == false) or 
						(not getAIConst().useOneGrenadePerTurn) ) then
						log(id, "and target was not blasted yet, this is my chance")
						local eat_fat_lim = getAIConst().useGrenadeProb + service.getEATandFATInRange(id, target, 6)
						local grenade_rnd = math.random()
						if(Humans[id].going_dir == "GRENADE") then
							grenade_rnd = 0.95
							Humans[id].going_dir = NONE
						end
						if (grenade_rnd > eat_fat_lim) then
							if (hasGrenade ~= getHandIndex(id)) then
								log(id, "Hey! Where's my grenade?  ..ah, here it is!")
								addUseItem(id, hasGrenade)
							end
							log(id, "FIRE IN THE HOLE!",grenade_rnd,eat_fat_lim)
							Humans[id].attack_type = "GRENADE"
							Humans[id].blasted_target = target
							attackGrenade(id, target, b_soldier.getGrenadeMistake(id))
							Humans[id].moveonly = false
							Humans[id].attacked = true
							return(true)
						else
							log(id, "damn, bad luck. grenade_rnd = ".. grenade_rnd.." | eat_fat_lim = "..eat_fat_lim.." | "..grenade_rnd.." < "..eat_fat_lim)
						end
					else
						log(id, "but target has already had its cut of grenades during this turn, rules are rules")
					end
				else
					log(id, "but NOT dangerous, why waste a grenade?")
				end
			else
				log (id, "but distance not good ("..dist..")")
			end
		else
			log(id, "No grenade to throw")
		end
		if(Humans[id].going_dir == "GRENADE") then
			Humans[id].going_dir = NONE
		end
		return(false)
	end,

	attackKnownTargetByGrenade = function(id,tx,ty,tz,tf,tid)
		local hasGrenade = getGrenade(id, "not_stun")
		if (hasGrenade ~= -1) then
			log(id, "I have a grenade for",tid)
			local dist = service.person2point_distance(id, tx, ty, tz)
			if((dist > getAIConst().minGrenadeRange) and (dist < grenadeMaxDistance(id))) then
				log(id, "and target is far enough")
				if (service.isTargetDangerous(tid) and 
				        isRayInterrupted(id, tx, ty, tz, dist) and
					(relations(team(id),team(tid)) == ENEMY)) then
					log(id, "and target is DANGEROUS and under obstacles")
					if( (Humans[tid].blasted == false) or (not isEasyLevel())) then
						log(id, "and target was not blasted yet, this is my chance")
						local eat_fat_lim = getAIConst().useGrenadeProb + service.getEATandFATInRangeForPoint(id, tx, ty, tz, 6)
						local grenade_rnd = math.random()
						if (Humans[id].going_dir == "GRENADE") then
							grenade_rnd = 0.95
							Humans[id].going_dir = NONE
						end
						if (grenade_rnd > eat_fat_lim) then
							if (hasGrenade ~= getHandIndex(id)) then
								log(id, "Hey! Where's my grenade?  ..ah, here it is!")
								addUseItem(id, hasGrenade)
							end
							log(id, "FIRE IN THE HOLE!")
							Humans[id].attack_type = "GRENADE"
							Humans[id].blasted_target = tid

							local x,y,z,f = getPosition(id)
							if(f<tf) then
								tz = tz+0
							else
								tz = tz-1
							end

							attackLocation(id, tx, ty, tz, b_soldier.getGrenadeMistake(id))
							Humans[id].moveonly = false
							Humans[id].attacked = true
							return(true)
						else
							log(id, "damn, bad luck. grenade_rnd = ".. grenade_rnd.." | eat_fat_lim = "..eat_fat_lim.." | "..grenade_rnd.." < "..eat_fat_lim)
						end
					else
						log(id, "but target has already had its cut of grenades during this turn, rules are rules")
					end
				else
					log(id, "but NOT dangerous, why waste a grenade?")
				end
			else
				log (id, "but distance not good ("..dist..")")
			end
		else
			log(id, "No grenade to throw")
		end
		Humans[id].going_dir = NONE
		return(false)
	end,

	attackTargetByMelee = function(id, target, attackType)
		meleeAttack(id, target)
		Humans[id].attack_type = attackType
		Humans[id].moveonly = true
		Humans[id].attacked = true
	end,

	isRoaming = function(id)
		return(Humans[id].roaming ~= nil)
	end,

	setRoaming = function(id, rx, ry, rz, rf, rradius, rintensivity, rinterval)
		log(id,"*** Set Roaming",rintensivity)
		if(b_soldier.isRoaming(id)) then
			log(id,"**** ALREADY in roaming!")
		end
		local rtime = time()
		Humans[id].roaming = 
		{
			x = rx,
			y = ry,
			z = rz,
			f = rf,
			time = rtime,
			radius = rradius,
			intensivity = rintensivity,
			interval = rinterval,
		}			
	end,

	setLazyRoaming = function(id, rx, ry, rz, rf)
		b_soldier.setRoaming(id, rx, ry, rz, rf, 
			getAIConst().lazyRoamRadius, getAIConst().lazyRoamIntensivity, getAIConst().lazyRoamInterval)
	end,

	setStrongRoaming = function(id, rx, ry, rz, rf)
		b_soldier.setRoaming(id, rx, ry, rz, rf, 
			getAIConst().roamRadius, 1.0, getAIConst().roamInterval)
	end,

	clearRoaming = function(id)
		if(Humans[id].roaming ~= nil) then
			log(id,"Clear roaming...")
		        Humans[id].roaming = nil
		end
	end,

	checkRoaming = function(id)
		if(Humans[id].roaming~=nil) then
			if(	(Humans[id].roaming.time>time()) or
				(time()-Humans[id].roaming.time>Humans[id].roaming.interval+math.random(0,5))) then
				b_soldier.clearRoaming(id)
			else
				if((Humans[id].roaming.skipTime==nil) or
					(Humans[id].roaming.skipTime>time()) or
					(time()-Humans[id].roaming.skipTime>math.random(getAIConst().lazyRoamLowTime,getAIConst().lazyRoamUpTime))) then
					local intensivity = Humans[id].roaming.intensivity
					local radius = Humans[id].roaming.radius
					log(id,"Try roaming now...",intensivity)
					local bx, by, bz = service.randomPointAroundPoint(
						Humans[id].roaming.x, Humans[id].roaming.y, Humans[id].roaming.z, 
						math.random(1,radius))
					if(math.random()<intensivity) then
						local mode = getAIConst().TBSoundStalkMode
						if(isGameInRT()) then
							mode = getAIConst().RTSoundStalkMode
						end
						if(mode=="run") then
							mode = b_soldier.selectMoveType(id)
						end
						addSmartMove(id, mode, bx, by, bz, Humans[id].roaming.f)
						Humans[id].attacked = false
						Humans[id].moveonly = true
						return(true)
					end
					if((math.random()<intensivity) and
						addRotate(id, bx, by, bz)) then
						Humans[id].attacked = false
						Humans[id].moveonly = true
						return(true)
					end
					log(id,"Skip roaming now...")
					Humans[id].roaming.skipTime = time()
				end
			end
		end
		return(false)
	end,

	soundReaction = function(id, idle, time, strategy)
		local sound = sounds.getDangerousSound(id)
		if( (sound~=nil) and
			(Humans[id].priority <= 0.1) and
			(not isUnitValid(Humans[id].assigned_target))) then

			local sdist = service.person2point_distance(id, sound.x, sound.y, sound.z)
			log(id, "  ", sound.type, sdist)
			if ((sound.type == "shot") or 
				(sound.type == "blast")) then
				local stalkers = service.checkSoundStalkers(id, sound.soundID)
				local allow_stalkers = getAIConst().TBSoundStalkers
				if(idle) then
					allow_stalkers = getAIConst().RTSoundStalkers
				end
				if(not service.isGuard(id)) then
					local checkedSound = sounds.getCheckedSound(id)
					if(not isValid(Humans[id].check)) then
						log(id, "    ")
						if (stalkers < allow_stalkers) then
							log(id, "   ,  ,   : ",stalkers)
							Humans[id].check = sound.soundID
						else
						        local fStalker,fDist = service.getFarestSoundStalker(id,sound)
							if(fDist>sdist) then
								log(id, "Farest stalker,",fStalker,"replace him")
								Humans[fStalker].check = NONE
								Humans[id].check = sound.soundID
							else
								log(id, "      ",stalkers)
								sounds.removeLastSound(id)
								Humans[id].attacked = false
								return true, 2
							end
						end
					elseif(Humans[id].check ~= sound.soundID) then
						log(id, " ")
						if (stalkers < allow_stalkers) then
							log(id, "   ,  ,   : ",stalkers)
							Humans[id].check = sound.soundID
						else
							log(id, "      ")
							if (IsAlive(checkedSound.owner)) then
								log(id, "     ")
                                                                sound = checkedSound
                                                                sdist = service.person2point_distance(id, sound.x, sound.y, sound.z)
							else
								log(id, "   ")
								sounds.removeLastSound(id)
								Humans[id].check = NONE
								Humans[id].attacked = false
								return true, 2
							end
						end
					else
						log(id, "   ")
					end
					
					if (sdist > 5) then
						b_soldier.clearRoaming(id)
						local movedist = b_soldier.selectMoveDistFromStrategy(strategy)
						if(movedist > sdist) then
							movedist = sdist - service.getRealRand(1,5)
						end
						if((service.isLeader(id) or service.isSniper(id)) and (movedist>1)) then
							movedist = movedist*3/4
						end
						local lx, ly, lz = service.pointAlongPointToPersonLine(sound.x, sound.y, sound.z, id, movedist)

						local mode = getAIConst().TBSoundStalkMode
						if(idle) then
							mode = getAIConst().RTSoundStalkMode
						end
						local mistake = movedist*getAIConst().medMoveMistake
						if(mode=="run") then
							mode = b_soldier.selectMoveType(id)
						end
						addSmartMove(id, mode, lx+service.getRealRand(-mistake, mistake), 
							ly+service.getRealRand(-mistake, mistake), lz, sound.f)
						Humans[id].moveonly = true
						Humans[id].attacked = false
						return true, 1
					else
						log(id, "Near, rotate")
						Humans[id].check = NONE
						b_soldier.setStrongRoaming(id, sound.x, sound.y, sound.z, sound.f)
						sounds.removeLastSound(id)
						Humans[id].attacked = false
					end
				else
					log(id, "Guard, test grenade or rotating")
					if( b_soldier.attackKnownTargetByGrenade(id, sound.x, sound.y, sound.z, 1, sound.owner) or
						addRotate(id, sound.x, sound.y, sound.z)) then
						sounds.removeLastSound(id)
						return true, 1
					end
				end
			elseif(sound.type == "step") then
				if (relations(team(id),team(sound.owner)) == ENEMY) then
					local lx, ly, lz = service.pointAlongPointToPersonLine(sound.x, sound.y, sound.z, id, sdist)
					local mistake = sdist*getAIConst().smallMoveMistake
					b_soldier.clearRoaming(id)
					addSmartMove(id, "sneak", lx+service.getRealRand(-mistake, mistake), 
						ly+service.getRealRand(-mistake, mistake), lz, sound.f)
					Humans[id].attacked = false
					Humans[id].moveonly = true
					return true, 1
				else
					local sound_clock = service.getPointClockSector(id, sound.x, sound.y)
					if(	(sound_clock > 2) and 
						(sound_clock < 10) and 
						(math.random() > 0.5) and
						addRotate(id, sound.x, sound.y, sound.z)) then
						sounds.removeLastSound(id)
						Humans[id].attacked = false
						return true, 1
					end								
				end
			elseif(sound.type == "bullet") then
				local x,y,z,f = getPosition(sound.owner)
				if(sounds.isSoundDangerous(sound.type,sdist)) then
					local ret = true
					Humans[id].underfire = Humans[id].underfire + 1
					log(id, "    ",Humans[id].underfire)
					if ((Humans[id].underfire > 2) and 
						not(canOneSeeOther(id, sound.owner))) then
						log(id, "    !!!   !!!")
						local movedist = b_soldier.selectMoveDistFromStrategy(strategy)
						local lx, ly, lz = service.pointAlongPointToPersonLine(x, y, z, id, -1*movedist)
						Humans[id].underfire = Humans[id].underfire - 1
						local mistake = movedist*getAIConst().smallMoveMistake
						b_soldier.clearRoaming(id)

						lx,ly = service.checkPointForBorders( x, y, 
							lx+service.getRealRand(-mistake, mistake), 
							ly+service.getRealRand(-mistake, mistake) )

						addSmartMove(id, "sneak", lx, ly, lz, f)
						Humans[id].attacked = false
						Humans[id].moveonly = true
					else
--						local team_attacker = team(sound.owner)
--						if(relations(team(id),team_attacker)~=ENEMY) then
--							service.incrementHate(id,sound.owner,0.5)
--						end
						log(id, "Try rotate to sound",Humans[id].underfire)
						ret = addRotate(id, x, y, z)
					end
					sounds.removeLastSound(id)
					Humans[id].attacked = false
					return ret, 1
				else
					sounds.removeLastSound(id)
					if(addRotate(id, x, y, z)) then
						Humans[id].attacked = false
						return true, 1
					end
				end
			end
		end
		return false, 0
	end,
	
	hurtReaction = function(id)
		if(isUnitValid(Humans[id].hurt)) then
			local hx, hy, hz, hf = getPosition(Humans[id].hurt)
			log(id, "  ",Humans[id].hurt)
			Humans[id].hurt = NONE
			Humans[id].attacked = false
			if(getPersonPose(id) == "lie") then
				poseUp(id)
				addRotate(id, hx, hy, hz)
				return(true)
			elseif(service.isGuard(id)) then
				if(poseDown(id)) then
					addRotate(id, hx, hy, hz)
					return(true)
				end
			end
			return(addRotate(id, hx, hy, hz))
		end
		return(false)
	end,
	
	tryLowerStatus = function(id)
		local rnd = math.random()
		if(Humans[id].status == "RED") then
			if (rnd > 0.5) then
				Humans[id].status = "YELLOW"
				log(id, "NEW STATUS: ",Humans[id].status)
			end
		elseif(Humans[id].status == "YELLOW") then
			if (rnd > 0.75) then
				Humans[id].status = "GREEN"
				log(id, "NEW STATUS: ",Humans[id].status)
			end
		else			
			return(false)
		end
		return(true)
	end,	
	
	clearDeadHurt = function(id)
	    	if(isUnitValid(Humans[id].hurt) and (not IsAlive(Humans[id].hurt))) then
			Humans[id].hurt = NONE
		end	
	end,		
	
	calmlyReaction = function(id,time,strategy)
		local ret = 0
		if(service.isPatrol(id) and isValid(Humans[id].patrol_routine)) then
			ret = b_patrol.think(id, time, strategy)
		elseif(service.isGuard(id) or isValid(Humans[id].post)) then
			ret = b_guard.think(id, time)
		elseif(service.isSquaddy(id)) then
			ret = b_squaddy.think(id, true)
		end
		Humans[id].attacked = false
		return(ret)
	end,							
	
	chooseKnownTarget = function(id,known_target,idle)
		local stalkers = service.checkStalkers(id, known_target.id)
		local allow_stalkers = getAIConst().TBKnownStalkers
		log(id, "test known target", known_target.id, stalkers)
		if(idle) then
			allow_stalkers = getAIConst().RTKnownStalkers
		end
		if(not isUnitValid(Humans[id].known)) then
			log(id, "   ")
			if (stalkers < allow_stalkers) then
				log(id, " ,  ,   :", stalkers)
				Humans[id].known = known_target.id
			else
				log(id, "   ", stalkers)
			        local fStalker,fDist = service.getFarestStalker(id,known_target.id)
				if(fDist>service.person2point_distance(id, known_target.x,known_target.y,known_target.z)) then
					log(id, "Farest stalker,",fStalker,"replace him")
					Humans[fStalker].known = NONE
					Humans[id].known = known_target.id
				else
					log(id, "try change known enemy")
					memory.removeKnownEnemy(id,known_target.id)
					local k = memory.getClosestKnownEnemy(id)
					if(k == nil) then
						log(id, "not found")
						Humans[id].attacked = false
						if(addRotate(id, known_target.x, known_target.y, known_target.z, getAIConst().rotateMistake)) then
							return known_target, true, 1
						else
							return known_target, true, 0
						end
					else
						return b_soldier.chooseKnownTarget(id,k,idle)
					end
				end
			end
		elseif (Humans[id].known ~= known_target.id) then
			log(id, "  ")
			if (stalkers < allow_stalkers) then
				log(id, " ,  ,   :", stalkers)
				Humans[id].known = known_target.id
			else
				log(id, "   ", stalkers)
				if(healthOK(Humans[id].known)) then
					log(id, "     ")
					known_target = b_soldier.restoreKnownTarget(id,Humans[id].known)
				else
					log(id, "   ")
					Humans[id].known = NONE
					Humans[id].attacked = false
					return known_target, true, 0
				end
			end
		else
			log(id, "   ")
		end
		return known_target, false, 0
	end,

	restoreKnownTarget = function(id,target)
		local known_target = memory.getKnownData(id,target)
        	if(known_target==nil) then
			log(id,"**** Use cheat!",target,"not in known, added it to list")
			memory.addKnownEnemy(id, target, time())
			known_target = memory.getKnownData(id,target)
		end
		return(known_target)
	end,

	isLastMove = function(id,strategy,dist)
		local ret = false
		if(not isGameInRT()) then
			ret = ((strategy>=getAIConst().maxStrategy) or (takeAP(id)-dist<4))
		end
		return(ret)
	end,

	isLeaderSayRetreat = function(id,target,strategy)
		if(Humans[id].retreat) then
			log(id, "!!!",Humans[id].leaderTurnsForSkip)
			local movedist = b_soldier.selectMoveDistFromStrategy(strategy)
			local lx, ly, lz = service.pointAlongPersonToPersonLine(target, id, -1*movedist)
			Humans[id].moveonly = true
			Humans[id].attacked = false
			addSmartMove(id, b_soldier.selectMoveType(id), lx, ly, lz, 1.0)
			if(b_soldier.isLastMove(id,strategy,movedist)) then
				addPose(id, "sit")
				Humans[id].turnDone = true
			end
			return(true)
		end
		return(false)
	end,

	isLeaderSayRetreatKnown = function(id,target,strategy)
		if(Humans[id].retreat) then
			log(id, "!!!",Humans[id].leaderTurnsForSkip)
			local movedist = b_soldier.selectMoveDistFromStrategy(strategy)
			local lx, ly, lz = service.pointAlongPointToPersonLine(target.x, target.y, target.z, id, -1*movedist)
			Humans[id].moveonly = true
			Humans[id].attacked = false
			addSmartMove(id, b_soldier.selectMoveType(id), lx, ly, lz, 1.0)
			if(b_soldier.isLastMove(id,strategy,movedist)) then
				addPose(id, "sit")
				Humans[id].turnDone = true
			end
			return(true)
		end
		return(false)
	end,

	tryWalkAroundKnown = function(id, target, strategy)
		local rnd = math.random()
		local dist = service.person2point_distance(id, target.x, target.y, target.z)
		local px, py, pz, pf = getPosition(id)
		local clock = service.getKnownPointClockSector(target.x, target.y, target.vx, target.vy, px, py)
log(id,"tryWalkAroundKnown clock: ",clock," for ",target.id)
		if( ((rnd < 0.5) or isUnitValid(Humans[id].going_target)) and
			(Humans[id].going_dir ~= "GRENADE") and
			((clock>8) or (clock<4)) and
			(dist > getAIConst().tooCloseDist*2)) then

			local dst = service.getWeaponRange(id)
			dst = math.random(dst/3,dst*3/4)
			if(dist>dst) then
				dist = dst
			end

			local dir = "left"
			if(clock>8) then
				dir = "right"
			end
			if(Humans[id].going_behind) then
				if((clock>=2) and (clock<=10)) then
					dir = Humans[id].going_dir.."behind"
				else
					dir = Humans[id].going_dir
				end
				Humans[id].going_behind = false
				Humans[id].going_target = NONE
				log(id, "  ", dir, dist)
			else
				if((clock>=2) and (clock<=10)) then
					dir = dir.."behind"
					Humans[id].going_behind = false
					Humans[id].going_target = NONE
				else
					Humans[id].going_behind = true
					Humans[id].going_target = target.id
				end
				log(id, " ", dir, dist)
			end
			addRotate(id, target.x, target.y, target.z, getAIConst().rotateMistake)
			local tx, ty, tz, tf = service.randomKnownTargetPoint(target.x, target.y, target.z, target.f, target.vx, target.vy, dir, dist)
			local movedist = b_soldier.selectMoveDistFromStrategy(strategy)
			local mistake = movedist*getAIConst().smallMoveMistake
			tx, ty, tz = service.pointAlongPointToPersonLine(tx, ty, tz, id, movedist)
			tx,ty = service.checkPointForBorders( px, py, 
				tx+service.getRealRand(-mistake, mistake), 
				ty+service.getRealRand(-mistake, mistake) )
			addSmartMove(id, b_soldier.selectMoveType(id), tx, ty, tz, tf)
			Humans[id].moveonly = true
			Humans[id].going_dir = dir
			Humans[id].attacked = false
			return(true)
		elseif((dist <= getAIConst().minGrenadeRange) and
			(getGrenade(id, "not_stun")~=-1)) then
			log(id,"To close, try retreat and use grenade",dist)
			local tx, ty, tz = service.pointAlongPointToPersonLine(target.x, target.y, target.z, id,
				dist - getAIConst().minGrenadeRange - 2)
			tx,ty = service.checkPointForBorders( px, py,  tx, ty )
			addSmartMove(id, b_soldier.selectMoveType(id), tx, ty, tz, target.f)
			Humans[id].moveonly = true
			Humans[id].going_dir = "GRENADE"
			Humans[id].going_behind = false
			Humans[id].going_target = NONE
			Humans[id].attacked = false
			return(true)
		else
			Humans[id].going_behind = false
			Humans[id].going_target = NONE
			Humans[id].going_dir = NONE
		end
		return(false)
	end,
	
	tryWalkAround = function(id, target, strategy)
		local rnd = math.random()
		local dist = service.person2person_distance(id, target)
		local px, py, pz, pf = getPosition(id)
		local clock = service.getPointClockSector(target, px, py)
log(id,"tryWalkAround clock: ",clock," for ",target)
		if( ((rnd < 0.5) or isUnitValid(Humans[id].going_target)) and
			(Humans[id].going_dir ~= "GRENADE") and
			((clock>8) or (clock<4)) and
			(dist > getAIConst().tooCloseDist*2)) then

			local dst = service.getWeaponRange(id)
			dst = math.random(dst/3,dst*3/4)
			if(dist>dst) then
				dist = dst
			end

			local dir = "left"
			if(clock>8) then
				dir = "right"
			end
			if (Humans[id].going_behind) then
				if((clock>=2) and (clock<=10)) then
					dir = Humans[id].going_dir.."behind"
				else
					dir = Humans[id].going_dir
				end
				log(id, "  ", dir, dist)
				Humans[id].going_behind = false
				Humans[id].going_target = NONE
			else
				if((clock>=2) and (clock<=10)) then
					dir = dir.."behind"
					Humans[id].going_behind = false
					Humans[id].going_target = NONE
				else
					Humans[id].going_behind = true
					Humans[id].going_target = target
				end
				log(id, " ", dir, dist)
			end
			local tx, ty, tz, tf = service.randomTargetPoint(target, dir, dist)
			local movedist = b_soldier.selectMoveDistFromStrategy(strategy)
			local mistake = movedist*getAIConst().smallMoveMistake
			tx, ty, tz = service.pointAlongPointToPersonLine(tx, ty, tz, id, movedist)
			tx,ty = service.checkPointForBorders( px, py,  
				tx+service.getRealRand(-mistake,mistake), ty+service.getRealRand(-mistake,mistake) )
			addSmartMove(id, b_soldier.selectMoveType(id), tx, ty, tz, tf)
			local tx, ty, tz, tf = getPosition(target)
			addRotate(id, tx, ty, tz)
			Humans[id].moveonly = true
			Humans[id].going_dir = dir
			Humans[id].attacked = false
			return(true)
		elseif((dist <= getAIConst().minGrenadeRange) and
			(getGrenade(id, "not_stun")~=-1)) then
			log(id,"To close, try retreat and use grenade",dist)
			local tx, ty, tz = service.pointAlongPersonToPersonLine(target, id,
				dist - getAIConst().minGrenadeRange - 2)
			tx,ty = service.checkPointForBorders( px, py, tx, ty )
			addSmartMove(id, b_soldier.selectMoveType(id), tx, ty, tz, pf)
			Humans[id].moveonly = true
			Humans[id].going_dir = "GRENADE"
			Humans[id].going_behind = false
			Humans[id].going_target = NONE
			Humans[id].attacked = false
			return(true)
		else
			Humans[id].going_behind = false
			Humans[id].going_target = NONE
			Humans[id].going_dir = NONE
		end
		return(false)
	end,
	
	changePoseAccordingMorale = function(id)
		if(math.random()<0.5) then
			local morale = getPersonParameter(id, "MORALE")
			if(getPersonPose(id) == "lie") then
				log(id, "I'm lying")
				if (getPersonParameter(id, "HEALTH") > 30) then
					log(id, "health OK")
					if(morale > getAIConst().moraleTresholdPoseUp) then
						log(id, "morale OK", "Going to sit")
						addPose(id, "sit")
						Humans[id].attacked = false
						Humans[id].moveonly = true
						return(true)
					else
						log(id, "not brave enough to get up")
					end
				else
					log(id, "low health - staying low")
				end
			elseif(morale < getAIConst().moraleTresholdPoseDown) then
				log(id, "Low morale - going prone")
				poseDown(id)
				Humans[id].attacked = false
				Humans[id].moveonly = true
 				return(true)
			end
		end
		return(false)
	end,
	
	doStrafe = function(id)
		local strafe_dist = 2
		local strafe_first_threshold = 0.5
		local strafe_second_threshold = 0.75
		Humans[id].attacked = false

		local choose_dir = function(threshold, last_dir)
			if (math.random() < threshold) then
				if(isValid(last_dir)) then
					return last_dir
				else
					return "left"
				end
			else
				return "right"
			end
		end

		if(isValid(Humans[id].last_strafe)) then
			Humans[id].last_strafe = choose_dir(strafe_second_threshold, Humans[id].last_strafe)
		else
			Humans[id].last_strafe = choose_dir(strafe_first_threshold, NONE)
		end
		addStrafe(id, Humans[id].last_strafe, strafe_dist)
		Humans[id].moveonly = true
		Humans[id].attacked = false
	end,
	
 	attackTargetByMeleeOrFlee = function(id,target,strategy)
 	
		isBrave = function(id)
			local morale = getPersonParameter(id, "MORALE")
			log(id,"Morale ",morale)
			if(morale<getAIConst().moraleTresholdFlee) then
			    	return(false)
			else
			    	return(true)
			end
		end
 	
		if(not isBrave(id)) then
			log(id, "Go-go-go away!!!")
			local movedist = b_soldier.selectMoveDistFromStrategy(strategy)
			local lx, ly, lz = service.pointAlongPersonToPersonLine(target, id, -1*movedist)
			addSmartMove(id, b_soldier.selectMoveType(id), lx, ly, lz, 1)
			Humans[id].attacked = false
			Humans[id].moveonly = true
		else
			log(id, "Try melee attack target")
			b_soldier.attackTargetByMelee(id,target,"HAND_ATTACK")
		end
	end,

	attackTargetByFirearm = function(id,target,strategy)
		local dist = service.person2person_distance(id, target)
		local tx, ty, tz, tf = getPosition(target)

		service.selectFireMode(id, target, dist, strategy)
	        local aimLevel = b_soldier.selectAimLevelFromStrategy(id,dist,strategy)

		log(id,"isRayInterrupted: ",
			isRayInterrupted(id, tx, ty, tz, dist),
			isRayInterrupted(id, tx, ty, tz+1, dist),
			isRayInterrupted(id, tx, ty, tz+2, dist))

		if(isRayInterrupted(id, tx, ty, tz+1, dist) and (takeAP(id)>2)) then
			local lx, ly, lz, lf = getPosition(id)
			log(id,"Obstacles exist")

			local morale = getPersonParameter(id, "MORALE")
			if( (math.abs(lz-tz)<2) or 
				(morale <= getAIConst().moraleTresholdPoseUp) or 
				(not poseUp(id)) ) then
				if(math.random()<getAIConst().strafeProb) then
			        	log(id, "Try strafe...")
			                addRotate(id,tx, ty, tz)
					b_soldier.doStrafe(id)
				else
				        log(id, "Ignore that.")
					log(id, "  :",aimLevel)
					Humans[id].attack_type = "SHOOTING"
					attackTarget(id, target, aimLevel)
					Humans[id].attacked = true
					Humans[id].moveonly = false
				end
			else
				Humans[id].attacked = false
				log(id,"Try standup...")
			end
		else
		    	log(id, "  :",aimLevel)
			Humans[id].attack_type = "SHOOTING"
			attackTarget(id, target, aimLevel)
			Humans[id].attacked = true
			Humans[id].moveonly = false
		end
	end,

	selectAimLevelFromStrategy = function(id,dist,strategy)
		local aimLevel   = 0
		if(dist>15) then
                	local WMConst = {}
			WMConst[0] = {}
			WMConst[0][1] = 0.0
			WMConst[0][2] = 1.0
			WMConst[0][3] = 2.0
			WMConst[0][4] = 3.0
			WMConst[0][5] = 4.0 
			table.setn(WMConst[0],5)
			WMConst[1] = {}
			WMConst[1][1] = 0.0
			WMConst[1][2] = 0.0
			WMConst[1][3] = 1.0
			WMConst[1][4] = 2.0
			WMConst[1][5] = 3.0 
			table.setn(WMConst[1],5)
			WMConst[2] = {}
			WMConst[2][1] = 0.0
			WMConst[2][2] = 0.0
			WMConst[2][3] = 0.0
			WMConst[2][4] = 1.0
			WMConst[2][5] = 2.0
			table.setn(WMConst[2],5)
			WMConst[3] = {}
			WMConst[3][1] = 0.0
			WMConst[3][2] = 0.0
			WMConst[3][3] = 0.0
			WMConst[3][4] = 0.0
			WMConst[3][5] = 0.0
			table.setn(WMConst[3],5)
			local WMindex = math.floor(dist*5/service.getWeaponRange(id))+1
			if(WMindex>5) then
				WMindex = 5
			end
			if(strategy>3) then
				strategy = 3
			end
			aimLevel = WMConst[strategy][WMindex]
			if(service.isSniper(id)) then
				aimLevel = aimLevel+1
			end
		end
		return(aimLevel)
	end,

	isAttackerTeam = function(id)
		return(isValid(BATTLE_DATA) and BATTLE_DATA.Enabled and
			(team(id)==BATTLE_DATA.Attacker))
	end,

	checkBreath = function(id)
		local breath = getPersonParameter(id, "BREATH")
		local border = getAIConst().TBMinBreathForJob
		local pose = "lie"
		if(isGameInRT()) then
			pose = "sit"
			border = getAIConst().RTMinBreathForJob
			if(getPersonPose(id)=="sit") then
				border = border*3
			end
		else
			if(not Humans[id].visibleAtLastTurn) then
				border = border*3
			end
			if(takeAP(id)<2) then
				pose = nil
			end
		end

		log(id,"** Breath check",Humans[id].visibleAtLastTurn,border,breath)

		if(breath<border) then
			stop(id)
			log(id,"To lower breath... Need rest...",breath,border)
			if(isValid(pose) and addPose(id,pose)) then 
				Humans[id].moveonly = true
				Humans[id].attacked = false
				Humans[id].turnDone = true
				return true, 1
			else
				return true, 0
			end
		end
		return false, 0
	end,

       	applyBreathPenalty = function(id)
		local breath = getPersonParameter(id, "BREATH")
		log(id,"Breath before:",getPersonParameter(id, "BREATH"))
		breath = breath-getAIConst().hitBreathPenalty
		if(breath<0) then
			if(isValid(fighter_tb.apAtEndTurn[id])) then
				fighter_tb.apAtEndTurn[id] = fighter_tb.apAtEndTurn[id]+(breath/5)
				if(fighter_tb.apAtEndTurn[id]<0) then
					fighter_tb.apAtEndTurn[id] = 0
				end
			end
			breath = 0
		end
		setPersonParameter(id, "BREATH", breath)
		if(isValid(fighter_tb.breathAtEndTurn[id])) then
			fighter_tb.breathAtEndTurn[id] = breath
		end
		log(id,"Breath after:",getPersonParameter(id, "BREATH"),breath)
	end,

	selectMoveType = function(id)
		local ret = "run"
		local breath = getPersonParameter(id, "BREATH")	
		if(breath<getAIConst().TBBreathForWalk) then
			if((((Humans[id].surrounded ~= true) and (Humans[id].surrounded ~= false)) or
				Humans[id].retreat) and
				(getPersonPose(id) == "lie")) then
		        	ret = "crawl"
			else
				ret = "walk"
			end
		end	
		return(ret)
	end,

	selectMoveDistFromStrategy = function(strategy)
		local movedist = getAIConst().maxMoveDist
		if(isGameInRT()) then
			strategy = math.random(0,3)	
		end
		if(strategy == 1) then
			movedist = getAIConst().medMoveDist
		elseif(strategy == 2) then
			movedist = getAIConst().defMoveDist
		elseif(strategy > 2) then
			movedist = getAIConst().minMoveDist
		end
		return(movedist)
	end,

	checkForFreeze = function(id,target,strategy)
		if((Humans[id].freeze>1) or
			((Humans[id].freeze>0) and (strategy>=getAIConst().maxStrategy))) then
log(id,"*** Freezed. Try melee.")
			b_soldier.attackTargetByMelee(id, target, "HAND_ATTACK")
			return(true)
		end
		return(false)
	end,

	bandageHuman = function(id,target)
		if(IsAlive(target) 
--			and (not healthOK(target))
			) then
			log(id, "Try heal human.",target)
			local maxHealth = getPersonParameter(target, "DURABILITYMAX")
			local health = getPersonParameter(target, "HEALTH")+math.random(15,20)
			local toBandage	= maxHealth - health
			if(toBandage>=0) then
				setPersonParameter(target, "HEALTH", health)
				setPersonParameter(target, "BANDAGED", toBandage)
				log(id, "Result:",getPersonParameter(target, "HEALTH"),getPersonParameter(target, "DURABILITYMAX"),getPersonParameter(target, "BANDAGED"),toBandage)
			end
			return(healthOK(target))
		end
		return(false)
	end,

	tryHealAlly = function(id,checkAll)
		local ret = false
		if(getAIConst().tryHealAlly) then
			local target, dist = service.getClosestDying(id,checkAll)
			if(target) then
				if(Humans[id].freeze>2) then
					log(id,"Freezed, ",Humans[id].freeze," mark ",target," as unreachiable")
					Humans[id].freeze = 0
					Humans[target].healed = "unreachiable"
					ret = b_soldier.tryHealAlly(id,checkAll)
				else
					Humans[target].healed = id
					local x,y,z,f = getPosition(target)	
					Humans[id].moveonly = true
					Humans[id].attacked = false
					if(dist<3) then
						addRotate(id,x,y,z)
						b_soldier.bandageHuman(id,target)
						Humans[target].healed = nil
						ret = addPose(id, "sit")
					else
						x,y,z = service.pointAlongPersonToPersonLine(id, target, service.getRealRand(1,3))
						addSmartMove(id, b_soldier.selectMoveType(id), x, y, z, f)
						ret = true
					end
				end
			end
		end
		return(ret)
	end,

	balanceBehaviors = function(id,visible_target)
		if(service.isGuard(id) and service.isThereEnemy(id)) then
			local guards = 1
			local ather  = 0

			local calcBehaviors = function(index,value)
				if(service.isGuard(value)) then
					guards = guards + 1
				elseif(not service.isPlayer(value)) then
					ather  = ather + 1
				end
			end

			local friends = service.getHumanList(id, "ally", false)
			local fCount = table.getn(friends)
			local enemies = service.getHumanList(id, "enemy", false)
			local eCount = table.getn(enemies)
			if(isUnitValid(visible_target) or (fCount>=eCount) or 
				(fCount==0) or b_soldier.isAttackerTeam(id)) then
				table.foreach(friends,calcBehaviors)
log(id,"Balance behaviors. Guards", guards, "Athers", ather, "All", fCount)
				if(guards>=ather) then
					if(((Humans[id].behavior == "guard") or (Humans[id].behavior == "squaddy_guard")) or
						((fCount==0) and (Humans[id].behavior == "fixed_guard"))) then
log(id,"Switch behavior to sniper")
						Humans[id].behavior = "sniper"
					end
					if(Humans[id].specialization == "guard") then
log(id,"Switch specialization to sniper")
						Humans[id].specialization = "sniper"
					end
				end
			end
		end
	end,

	meleeHackForKnown = function(id,known_target,dist)
calls.enter("b_soldier.meleeHackForKnown",id)
		local ret = false
		if(dist < getAIConst().forcedMeleeDist*2) then
			local diff = service.person2point_distance(known_target.id,known_target.x,known_target.y,known_target.z)
			if(diff<3) then
				if((dist>getAIConst().forcedMeleeDist) and (math.random()<0.5)) then
log(id,"Try move (melee hack)")
					local rx, ry, rz, rf = service.randomPoint(known_target.id, "behind", 
						service.getRealRand(0,getAIConst().forcedMeleeDist-1))
					rx,ry = service.checkUnitForBorders( id, rx, ry )
					addSmartMove(id, b_soldier.selectMoveType(id), rx, ry, rz, rf)
					Humans[id].moveonly = true
					Humans[id].attacked = false
				else
log(id,"Try melee (melee hack)")
                                    	b_soldier.attackTargetByMelee(id, known_target.id, "HAND_ATTACK")
				end
				ret = true
			end
		end
calls.leave("b_soldier.meleeHackForKnown",id)
		return(ret)
	end,

	tb_think = function(id, strategy, time)
calls.enter("b_soldier.tb_think",id)
		log(id, "TURN BASED: I AM A TOUGH SOLDIER")
		log(id, "knownEnemiesSize", table.getn(Humans[id].memory.known_enemies))
		log(id, "soundsSize", table.getn(Humans[id].memory.clear_sounds))

		sounds.resortSounds(id)

		local visible_target = service.closestVisibleEnemy(id)
		local known_target = memory.getClosestKnownEnemy(id)
		local lx, ly, lz, lf = getPosition(id)
		local tx, ty, tz, tf = getPosition(id)
		local dist = 0
		local movedist = getAIConst().defMoveDist
		local hand_index = getHandIndex(id)
		local gun_index = getGun(id, -1)
		local aimLevel = 0
		local melee = getMelee(id, false)
		local vt_count = Humans[id].visible_enemies.size

		b_soldier.balanceBehaviors(id,visible_target)

		service.retreatCheck(id)

		if(b_soldier.checkForDisappear(id)) then
calls.leave("b_soldier.tb_think",0)
			return(0)
		end

		if(service.isSquaddy(id)) then
			local res = b_squaddy.think(id, false)
			if (res ~= 0) then
				b_soldier.clearRoaming(id)
calls.leave("b_soldier.tb_think",res)
				return res
			end
		end
		
		if( service.isLeader(id) and b_squad_leader.think(id) ) then
calls.leave("b_soldier.tb_think",2)
			return 2
		end

		if((Humans[id].surrounded ~= true) and (Humans[id].surrounded ~= false)) then
			if((Humans[id].freeze>1) or
				((Humans[id].freeze>0) and (strategy>=getAIConst().maxStrategy))) then
				Humans[id].surrounded = false
				Humans[id].surroundTurnsForSkip = 0
			else
				log(id, "  . !!!")
				Humans[id].moveonly = true
				Humans[id].attacked = false
				Humans[id].known = NONE
				Humans[id].check = NONE
				b_soldier.clearRoaming(id)
				if((Humans[id].surroundTurnsForSkip == 1) and
					(service.getHealthPercent(id)<getAIConst().healthPercentToBandage)) then
					b_soldier.bandageHuman(id,id)
					if(not Humans[id].visibleAtLastTurn) then
						Humans[id].behavior = "fixed_guard"
					end
					addPose(id,"sit")
					Humans[id].turnDone = true
				else
					rx, ry, rz, rf = service.randomPoint(id, Humans[id].surrounded, 
						b_soldier.selectMoveDistFromStrategy(strategy))
					addSmartMove(id, b_soldier.selectMoveType(id), rx, ry, rz, rf)
				end
calls.leave("b_soldier.tb_think",1)
				return 1
			end
		end

		local processed, cmd = b_soldier.checkBreath(id)
		if(processed) then
calls.leave("b_soldier.rt_think",cmd)
			return(cmd)
		end

		if ((gun_index ~= hand_index) and (gun_index >= 0)) then
			log(id, "     .  ")
			addUseItem(id, gun_index)
			Humans[id].attacked = false
calls.leave("b_soldier.tb_think",1)
			return 1
		elseif ((melee ~= hand_index) and (melee >=0)) then
			log(id, "  . .")
			Humans[id].attacked = false
			addUseItem(id, melee)
calls.leave("b_soldier.tb_think",1)
			return 1
		elseif ((gun_index < 0) and (hand_index ~= melee)) then
		        log(id, "Weapon absent or empty")
			if(isUnitValid(visible_target)) then
				b_soldier.clearRoaming(id)
			        dist = service.person2person_distance(id, visible_target)
        			if((dist < getAIConst().forcedMeleeDist) and 
        				(math.random() < getAIConst().forcedMeleeProb)) then
					b_soldier.attackTargetByMelee(id,visible_target,"HAND_ATTACK")
				else	
					if(service.lootCheck(id)) then
						b_soldier.clearRoaming(id)
calls.leave("b_soldier.tb_think",1)
						return 1
					end
				end
			else
				if(service.lootCheck(id)) then
					b_soldier.clearRoaming(id)
calls.leave("b_soldier.tb_think",1)
					return 1
				end
			end
        	elseif (gun_index == hand_index) then
			log(id, "   ")
			local res = service.reloadCheck(id, gun_index, visible_target)
			if (res == true) then
				Humans[id].attacked = false
calls.leave("b_soldier.tb_think",1)
				return 1
			end
		elseif(hand_index == melee) then
			log(id, "    ")
		else
			log(id, "  ")
		end

		if((not isUnitValid(Humans[id].assigned_target)) or
			(not IsAlive(Humans[id].assigned_target))) then
			Humans[id].assigned_target = NONE
		else
			if(service.isSquaddy(id)) then
				if (canOneSeeOther(id, Humans[id].assigned_target)) then
					log(id, "  - .", Humans[id].assigned_target)
					visible_target = Humans[id].assigned_target
				else
					log(id, "  - .",Humans[id].assigned_target)
					known_target = b_soldier.restoreKnownTarget(id,Humans[id].assigned_target)
				end
			end
		end

		if(not isUnitValid(visible_target)) then

			if((known_target~=nil) and b_soldier.isLeaderSayRetreatKnown(id,known_target,strategy)) then
calls.leave("b_soldier.tb_think",cmd)				
				return 1
			end

			log(id, "  ")
			b_soldier.clearDeadHurt(id)
			if(isUnitValid(Humans[id].hurt) or sounds.isDangerousSoundPresent(id)) then
				log(id, "Check hurt", Humans[id].hurt)
				if(b_soldier.hurtReaction(id)) then
calls.leave("b_soldier.tb_think",1)
					return 1
				elseif(known_target == nil) then
					processed, cmd = b_soldier.soundReaction(id, false, time, strategy)
					if(processed) then
calls.leave("b_soldier.tb_think",cmd)
						return(cmd)
					end
				end				    
			end
			if(known_target == nil) then
				b_soldier.tryLowerStatus(id)
				if((not service.isGuard(id)) and 
--					(not service.isLeader(id)) and
					(       b_soldier.tryHealAlly(id,true) or
						(getAIConst().mayCheckLoot and service.lootCheck(id,true)) or
						b_soldier.checkRoaming(id))) then
calls.leave("b_soldier.tb_think",1)
					return(1)
				end
				local ret = b_soldier.calmlyReaction(id,time,strategy)
				if(ret==0) then
					if(not b_soldier.isRoaming(id)) then
						b_soldier.setLazyRoaming(id, lx, ly, lz, lf)
						ret = 2
					end
				end					
calls.leave("b_soldier.tb_think",0)
				return(ret)
----------------------------------------------------------------------------------------------------------
			else
				b_soldier.clearRoaming(id)
				log(id, "  :", known_target.id, service.person2point_distance(known_target.id,known_target.x,known_target.y,known_target.z))
				if(isUnitValid(Humans[id].going_target)) then
					log(id, "       :", Humans[id].going_target)
					if (known_target.id ~= Humans[id].going_target) then
						log(id, "        :", known_target.id, ",        ")
						known_target = b_soldier.restoreKnownTarget(id,Humans[id].going_target)
					end
				end

				if(not healthOK(known_target.id)) then
					log(id, "  ")
					memory.removeKnownEnemyForAll(id, known_target.id)
					sounds.removeSoundsFromForAll(id,known_target.id)
calls.leave("b_soldier.tb_think",2)
					return 2
				end

				if (Humans[id].status == "GREEN") then
					Humans[id].status = "YELLOW"
					log(id, "NEW STATUS:", Humans[id].status)
				end

				if (service.isGuard(id)) then
					local ret = 0
					if(addRotate(id, known_target.x, known_target.y, known_target.z, getAIConst().rotateMistake)) then
						Humans[id].attacked = false
						ret = 1
					end
calls.leave("b_soldier.tb_think",0)
					return(ret)
				end
				
				known_target, processed, cmd = b_soldier.chooseKnownTarget(id,known_target,false)
				if(processed) then
calls.leave("b_soldier.tb_think",cmd)
					return(cmd)
				end					

				dist = service.person2point_distance(id, known_target.x, known_target.y, known_target.z)
				if(addRotate(id, known_target.x, known_target.y, known_target.z, getAIConst().rotateMistake)) then
					Humans[id].attacked = false
					log(id, "rotate to target, may be visible?",known_target.id)
calls.leave("b_soldier.tb_think",1)
					return 1
				end

				if(	service.isTargetDangerous(known_target.id) ) then
					log(id, "    !")
					if(b_soldier.tryWalkAroundKnown(id,known_target,strategy)) then
calls.leave("b_soldier.tb_think",1)
						return 1
					end
				else
					log(id, "     ")
				end

				movedist = b_soldier.selectMoveDistFromStrategy(strategy)
				if (movedist > dist) then
					movedist = dist - service.getRealRand(1,4)
				end
				if (movedist < 0.5) then
					movedist = 0
				end

				if(dist < 3) then
					log(id, "      -      ")
					b_soldier.setStrongRoaming(id, known_target.x, known_target.y, known_target.z, known_target.f)
					memory.removeKnownEnemyForAll(id, known_target.id)
					sounds.removeSoundsFromForAll(id,known_target.id)
calls.leave("b_soldier.tb_think",2)
					return 2
				end

				if ((movedist ~= 0) or 
					(Humans[id].going_dir == "GRENADE")
					) then
					if(b_soldier.attackKnownTargetByGrenade(id,known_target.x, known_target.y, known_target.z, known_target.f, known_target.id) or
						b_soldier.meleeHackForKnown(id,known_target,dist)) then
calls.leave("b_soldier.tb_think",1)
						return 1
					end
					if((service.isLeader(id) or service.isSniper(id)) and (movedist>1)) then
						movedist = movedist*3/4
			        	end
					tx, ty, tz = service.pointAlongPointToPersonLine(known_target.x, known_target.y, known_target.z, id, movedist)
					local mistake = movedist*getAIConst().smallMoveMistake
					addSmartMove(id, b_soldier.selectMoveType(id), tx+service.getRealRand(-mistake,mistake), 
						ty+service.getRealRand(-mistake,mistake), tz, known_target.f)
					Humans[id].moveonly = true
					Humans[id].attacked = false
calls.leave("b_soldier.tb_think",1)
					return 1
				else
					log(id, "      ")
					b_soldier.setStrongRoaming(id, known_target.x, known_target.y, known_target.z, known_target.f)
					Humans[id].attacked = false
calls.leave("b_soldier.tb_think",1)
					return 2
				end
			end
---------------------------------------------------------------------------------------------------------
		else
			log(id, "  :", visible_target)
			b_soldier.clearRoaming(id)
			if(fighter_tb.getTurn(id) > getAIConst().turnForVisibleReport) then
				service.reportEnemy2Friends(id, visible_target, getAIConst().visibleReportProb)
			end

			if(b_soldier.hurtReaction(id)) then
calls.leave("b_soldier.tb_think",1)
				return 1
			end
			
			if(service.isSniper(id) and (hand_index ~= melee)) then
				local result = b_sniper.think(id, strategy, visible_target)
calls.leave("b_soldier.tb_think",result)
				return result
			end
			
			Humans[id].priority = 0.8
		
			local d_target = service.closestDangerousEnemy(id)
			if(not isUnitValid(d_target)) then
				d_target = visible_target
			end
			if(b_soldier.isLeaderSayRetreat(id,d_target,strategy)) then
calls.leave("b_soldier.tb_think",1)
				return 1
			end	

			tx, ty, tz, tf = getPosition(visible_target)
			dist = service.person2person_distance(id, visible_target)
			if not(service.isTargetDangerous(visible_target)) then
				log(id, "   !")
				Humans[visible_target].dangerous = false
				local dangerous_target = service.closestDangerousEnemy(id) 
				if(not isUnitValid(dangerous_target)) then
					log(id, "  !")
					Humans[id].priority = 0.2
					if(math.random()<0.7) then
						log(id, "Try melee attack target")
						b_soldier.attackTargetByMelee(id,visible_target,"HAND_ATTACK")
calls.leave("b_soldier.tb_think",1)
	        				return 1
					end
				else
					visible_target = dangerous_target
					Humans[dangerous_target].dangerous = true
					tx, ty, tz, tf = getPosition(dangerous_target)
					dist = service.person2person_distance(id, dangerous_target)
					log(id, "  :", dangerous_target)
				end
			else
				log(id, "  !")
				Humans[visible_target].dangerous = true
			end

			if(b_soldier.changePoseAccordingMorale(id)) then
calls.leave("b_soldier.tb_think",1)
				return 1
			end
			
			if(service.isGuard(id)) then
				if((dist < getAIConst().forcedMeleeDist) and 
        				(math.random() < getAIConst().forcedMeleeProb)) then
					b_soldier.attackTargetByMelee(id,visible_target,"HAND_ATTACK")
				else
					if(not b_soldier.attackTargetByGrenade(id,visible_target)) then
						b_soldier.attackTargetByFirearm(id, visible_target, strategy)
					end
				end
calls.leave("b_soldier.tb_think",1)
				return 1
			end
			
			if(b_soldier.attackTargetByGrenade(id,visible_target)) then
calls.leave("b_soldier.tb_think",1)
				return 1
			end			
			if(gun_index == hand_index) then
				local needMoveCloser = not(inRange(id, visible_target))
				if(not needMoveCloser) then
					if(service.isFriendInLos(id, visible_target)) then
						log(id, "   ")
						if(     (not b_soldier.checkForFreeze(id,visible_target,strategy)) and
						 	(not b_soldier.tryWalkAround(id,visible_target,strategy))) then
						 	addRotate(id,tx, ty, tz)	
							b_soldier.doStrafe(id)
						end
						Humans[id].lastMoveCommand = nil
calls.leave("b_soldier.tb_think",1)
						return 1
					end
					local max_miss_tries = getAIConst().soldierMaxMissTries
					local should_move_closer = false
                                        if((not isUnitValid(Humans[id].current_target)) or (visible_target ~= Humans[id].current_target)) then
						log(id, "  ")
						Humans[id].current_target = visible_target
						Humans[id].target_health = getPersonParameter(visible_target, "HEALTH")
						Humans[id].try = 0
						Humans[id].attacked = false
					else
						log(id, "      ",Humans[id].try)
						local target_health = getPersonParameter(visible_target, "HEALTH")
						if (Humans[id].target_health > target_health) then
							log(id, "  !")
							if(Humans[id].attacked) then
								log(id, "  !    !")
								Humans[id].try = 0
								Humans[id].target_health = target_health
							else
								log(id, "   - !")
							end
						else
							log(id, "   !")
							if(Humans[id].attacked) then
								log(id, "Missed last shoot.",Humans[id].try)
                                				Humans[id].try = Humans[id].try + 1
								if((Humans[id].try>=max_miss_tries) and (takeAP(id)>4)) then
									log(id, "Must change location.")	
									should_move_closer = true		
									Humans[id].try = 0
								end
							end
						end
					end
					if(should_move_closer) then
						movedist = b_soldier.selectMoveDistFromStrategy(strategy)
                        	       		if(movedist > dist) then
							movedist = dist/2
               						if (movedist < 2) then
								movedist = 0
							end
						end
						if( (dist - movedist - getAIConst().tooCloseDist) < 0) then
							Humans[id].freeze =  5
						end
					end
					if(should_move_closer) then
					   	if(b_soldier.checkForFreeze(id,visible_target,strategy)) then
calls.leave("b_soldier.tb_think",1)
					   		return(1)
					   	end
						log(id,"must change distance",dist)
					       	if( ((dist<service.getWeaponRange(id)*3/4) and 
					       		(math.random()<getAIConst().tryWalkAroundProb)) or 
					       		(movedist==0) or
					       		service.isLeader(id)) then
					       		log(id,"try strafe or walk around")
				        		if(not b_soldier.tryWalkAround(id,visible_target,strategy)) then
					        		addRotate(id,tx, ty, tz)
								b_soldier.doStrafe(id)
							end
							movedist = 0
					        else
					        	log(id,"move close")
        						lx, ly, lz = service.pointAlongPersonToPersonLine(visible_target, id, movedist)
							addSmartMove(id, b_soldier.selectMoveType(id), lx, ly, lz, tf)
						end
						Humans[id].lastMoveCommand = nil
						Humans[id].attacked = false
						Humans[id].moveonly = true
					else
						if((dist < getAIConst().forcedMeleeDist) and 
        						(math.random() < getAIConst().forcedMeleeProb)) then
        						movedist = dist
							b_soldier.attackTargetByMelee(id,visible_target,"HAND_ATTACK")
						else
							movedist = 10
							b_soldier.attackTargetByFirearm(id,visible_target,strategy)
						end
					end
					if(b_soldier.isLastMove(id,strategy,movedist) and 
						(getPersonPose(id) == "stand")) then
log(id,"***** max strategy, sitdown")
						addPose(id, "sit")
						Humans[id].turnDone = true
					end
				else
					if(not b_soldier.checkForFreeze(id,visible_target,strategy)) then
						if((math.random()>=getAIConst().tryWalkAroundProb) or
							(not b_soldier.tryWalkAround(id,visible_target,strategy))) then
							movedist = b_soldier.selectMoveDistFromStrategy(strategy)
					        	if(service.isLeader(id) and (movedist>1)) then
								movedist = movedist/2
					        	end
							lx, ly, lz = service.pointAlongPersonToPersonLine(visible_target, id, movedist)
							addSmartMove(id, b_soldier.selectMoveType(id), lx, ly, lz, tf)
						end
						Humans[id].moveonly = true
						Humans[id].attacked = false
						Humans[id].lastMoveCommand = nil
					end
        			end
			else
				if(melee == hand_index) then
					b_soldier.attackTargetByMelee(id,visible_target,"KNIFE_ATTACK")
				else
					log(id, "       ,   !")
					b_soldier.attackTargetByMeleeOrFlee(id,visible_target,strategy)
				end
			end
calls.leave("b_soldier.tb_think",1)
			return 1
		end
calls.leave("b_soldier.tb_think",0)
		return 0
	end,

--------------------
-----REAL TIME------
--------------------
	rt_think = function(id, time)
calls.enter("b_soldier.rt_think",id)
		log(id, "REAL TIME: I AM A TOUGH SOLDIER")

		sounds.resortSounds(id)

		b_soldier.balanceBehaviors(id,NONE)

		Humans[id].attacked = false
		local hand_index = getHandIndex(id)
		local gun_index = getGun(id, -1)

		if(service.isSquaddy(id)) then
			local res = b_squaddy.think(id, false)
			if (res ~= 0) then
calls.leave("b_soldier.rt_think",res)
				return res
			end
		end

		if( service.isLeader(id) and b_squad_leader.think(id)) then
calls.leave("b_soldier.rt_think",2)
			return 2
		end

		if(gun_index < 0) then
		        log(id, "Weapon absent or empty")
			log(id, "    !")
			if(service.lootCheck(id)) then
calls.leave("b_soldier.rt_think",1)
				return(1)
			end
		end

		local known_target = memory.getClosestKnownEnemy(id)						--  =   
		local lx, ly, lz, lf = getPosition(id)								--    
		local tx, ty, tz, tf = getPosition(id)								--   
		local dist = 0														--    
		local movedist = getAIConst().defMoveDist							--    -   
		
		if((not isUnitValid(Humans[id].assigned_target)) or
			(not IsAlive(Humans[id].assigned_target))) then
			Humans[id].assigned_target = NONE
		else
			if(service.isSquaddy(id)) then
				known_target = b_soldier.restoreKnownTarget(id,Humans[id].assigned_target)
			end
		end
		
		local visible_target = service.closestVisibleEnemy(id)		
		if(isUnitValid(visible_target)) then
			local ret = b_soldier.tb_think(id, 0, time)
calls.leave("b_soldier.rt_think",ret)
			return(ret)
		end

		local processed, cmd = b_soldier.checkBreath(id)
		if(processed) then
calls.leave("b_soldier.rt_think",cmd)
			return(cmd)
		end

----------------------------------------------------------------------------------------------------------

		b_soldier.clearDeadHurt(id)
		if(isUnitValid(Humans[id].hurt) or 
			sounds.isDangerousSoundPresent(id)) then
			log(id, "Check hurt", Humans[id].hurt)
			if(b_soldier.hurtReaction(id)) then
calls.leave("b_soldier.rt_think",1)
				return 1
			elseif(known_target == nil) then
				processed, cmd = b_soldier.soundReaction(id,true,time,nil)
				if(processed) then
calls.leave("b_soldier.rt_think",cmd)
					return(cmd)
				end
			end
		end
		if(known_target == nil) then
			b_soldier.tryLowerStatus(id)
			if
				(
--				(not service.isLeader(id)) and 
				(not service.isGuard(id)) and
				(b_soldier.tryHealAlly(id,true) or
				(getAIConst().mayCheckLoot and service.lootCheck(id,true)) or
				b_soldier.checkRoaming(id))) then
calls.leave("b_soldier.rt_think",1)
				return(1)
			end
			local ret = b_soldier.calmlyReaction(id,time)
			if(ret~=0) then
calls.leave("b_soldier.rt_think",ret)
				return(ret)
			end
			if((not b_soldier.isRoaming(id)) and
				(service.areThereDead() or 
				Sectors[CUR_MISSION.Name].isClean or
				(isValid(BATTLE_DATA) and BATTLE_DATA.Enabled)) and
				(not service.isGuard(id))
				) then
				b_soldier.setLazyRoaming(id, lx, ly, lz, lf)
			end
calls.leave("b_soldier.rt_think",0)
			return(0)
		elseif (canIssueOrder(id)) then
		--   
			Humans[id].priority = 0.5
			clearAllOrders(id)
			log(id, " ")
			log(id, "  : ",known_target.id)

			if(not healthOK(known_target.id)) then
				log(id, "  ")
				memory.removeKnownEnemyForAll(id, known_target.id)
				sounds.removeSoundsFromForAll(id,known_target.id)
calls.leave("b_soldier.rt_think",2)
				return 2
			end

			if (Humans[id].status == "GREEN") then
				Humans[id].status = "YELLOW"
				log(id, "NEW STATUS: ",Humans[id].status)
			end
			
			if (service.isGuard(id)) then
				local ret = 0
				if(addRotate(id, known_target.x, known_target.y, known_target.z, getAIConst().rotateMistake)) then
					ret = 1
				end
calls.leave("b_soldier.rt_think",0)
				return(ret)
			end

			known_target, processed, cmd = b_soldier.chooseKnownTarget(id,known_target,true)
			if(processed) then
calls.leave("b_soldier.rt_think",cmd)				
				return(cmd)
			end

			if(b_soldier.isLeaderSayRetreatKnown(id,known_target,nil)) then
calls.leave("b_soldier.rt_think",1)
				return 1
			end	
			
			if(addRotate(id, known_target.x, known_target.y, known_target.z, getAIConst().rotateMistake)) then
calls.leave("b_soldier.rt_think",1)
				return 1
			end

			dist = service.person2point_distance(id, known_target.x, known_target.y, known_target.z)
			if(dist < 3) then
				log(id, "      -      ")
				b_soldier.setLazyRoaming(id, known_target.x, known_target.y, known_target.z, known_target.f)
				memory.removeKnownEnemyForAll(id, known_target.id)
calls.leave("b_soldier.rt_think",2)
				return(2)
			end

			movedist = b_soldier.selectMoveDistFromStrategy()
	        	if (movedist > dist) then
				movedist = dist - service.getRealRand(1,4)
			end
			if (movedist < 0.5) then
				movedist = 0
			end
			if (movedist ~= 0) then
				lx, ly, lz = service.pointAlongPointToPersonLine(known_target.x, known_target.y, known_target.z, id, movedist)
				local mistake = movedist*getAIConst().smallMoveMistake
				addSmartMove(id, b_soldier.selectMoveType(id), lx+service.getRealRand(-mistake, mistake), 
					ly+service.getRealRand(-mistake, mistake), lz, known_target.f)
calls.leave("b_soldier.rt_think",1)
				return 1
			else
				log(id, "      ")
				b_soldier.setLazyRoaming(id, known_target.x, known_target.y, known_target.z, known_target.f)
				if(poseUp(id)) then
calls.leave("b_soldier.rt_think",1)
					return 1
				end
			end
calls.leave("b_soldier.rt_think",0)
			return 0
		elseif not(idle(id)) then
			processed, cmd = b_soldier.checkBreath(id)
			if(processed) then
calls.leave("b_soldier.rt_think",cmd)
				return(cmd)
			end
			log(id, " ,  !")
calls.leave("b_soldier.rt_think",2)
			return 2
		end
calls.leave("b_soldier.rt_think",0)
		return 0
	end,
}